<?php
require_once 'includes/config.php';

// Cek jika user belum login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Verifikasi CSRF token
if (!verifyCSRFToken($_POST['csrf_token'])) {
    $_SESSION['error'] = "Invalid security token!";
    header("Location: dashboard.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
    $note = trim($_POST['note']);
    $nd_status = $_POST['nd_status'];
    
    if ($id && updateDistributedNumber($id, $note, $nd_status)) {
        $_SESSION['success'] = "Data berhasil diupdate!";
    } else {
        $_SESSION['error'] = "Gagal mengupdate data!";
    }
    
    // Redirect kembali ke dashboard dengan mempertahankan filter yang aktif
    $query_string = http_build_query($_GET);
    $redirect_url = 'dashboard.php' . ($query_string ? "?$query_string" : '');
    header("Location: $redirect_url");
    exit();
}

header("Location: dashboard.php");
exit(); 