<?php
session_start();

// Database configuration for auth (pojodmoz_callsa)
$host = 'localhost';
$dbname = 'pojodmoz_callsa';
$username = 'pojodmoz_callUsr';
$password = 'PMFD9)xLqXBS';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Koneksi database gagal: " . $e->getMessage());
}

// Database configuration for marketing data (pojodmoz_callmkt)
try {
    $pdo_mkt = new PDO("mysql:host=$host;dbname=pojodmoz_callmkt", $username, $password);
    $pdo_mkt->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo_mkt->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    die("Koneksi database marketing gagal: " . $e->getMessage());
}

// Security functions
function generateCSRFToken() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verifyCSRFToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

function sanitize_input($data) {
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function checkUserLogin($table, $username) {
    global $pdo;
    try {
        $stmt = $pdo->prepare("SELECT * FROM $table WHERE username = ? AND deleted_at IS NULL AND active = 'active'");
        $stmt->execute([$username]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        error_log("Error checking user login: " . $e->getMessage());
        return false;
    }
}

// Function to get marketing data
function getMarketingData($filters = []) {
    global $pdo_mkt;
    
    $where = [];
    $params = [];
    
    if (!empty($filters['action'])) {
        $where[] = "status = ?";
        $params[] = $filters['action'];
    }
    
    if (!empty($filters['marketing_id'])) {
        $where[] = "marketing_id = ?";
        $params[] = $filters['marketing_id'];
    }
    
    if (!empty($filters['date_from'])) {
        $where[] = "original_call_date >= ?";
        $params[] = $filters['date_from'] . ' 00:00:00';
    }
    
    if (!empty($filters['date_to'])) {
        $where[] = "original_call_date <= ?";
        $params[] = $filters['date_to'] . ' 23:59:59';
    }
    
    $whereClause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';
    
    $sql = "SELECT * FROM distributed_numbers $whereClause ORDER BY original_call_date DESC";
    
    try {
        $stmt = $pdo_mkt->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        error_log("Error getting marketing data: " . $e->getMessage());
        return [];
    }
}

// Function to get marketing name
function getMarketingName($marketing_id) {
    global $pdo;
    try {
        $stmt = $pdo->prepare("SELECT nama_lengkap FROM marketing WHERE id = ?");
        $stmt->execute([$marketing_id]);
        $result = $stmt->fetch();
        return $result ? $result['nama_lengkap'] : 'Unknown';
    } catch(PDOException $e) {
        error_log("Error getting marketing name: " . $e->getMessage());
        return 'Unknown';
    }
}

// Function to get all active marketing
function getAllMarketing() {
    global $pdo;
    try {
        $stmt = $pdo->prepare("SELECT id, nama_lengkap FROM marketing WHERE deleted_at IS NULL");
        $stmt->execute();
        return $stmt->fetchAll();
    } catch(PDOException $e) {
        error_log("Error getting marketing list: " . $e->getMessage());
        return [];
    }
}

// Tambahkan fungsi ini di bagian bawah file config.php
function updateDistributedNumber($id, $note, $nd_status) {
    global $pdo_mkt;
    try {
        $stmt = $pdo_mkt->prepare("
            UPDATE distributed_numbers 
            SET note = ?, nd_status = ?, updated_at = CURRENT_TIMESTAMP 
            WHERE id = ?
        ");
        return $stmt->execute([$note, $nd_status, $id]);
    } catch(PDOException $e) {
        error_log("Error updating distributed number: " . $e->getMessage());
        return false;
    }
}

// Fungsi untuk paginasi
function paginateData($data, $page = 1, $perPage = 10) {
    // Total data
    $totalData = count($data);
    
    // Total halaman
    $totalPages = ceil($totalData / $perPage);
    
    // Pastikan page tidak kurang dari 1 dan tidak lebih dari total pages
    $page = max(1, min($page, $totalPages));
    
    // Hitung offset
    $offset = ($page - 1) * $perPage;
    
    // Ambil data sesuai halaman
    $paginatedData = array_slice($data, $offset, $perPage);
    
    return [
        'data' => $paginatedData,
        'total_data' => $totalData,
        'total_pages' => $totalPages,
        'current_page' => $page
    ];
}
?> 